#!/usr/bin/python3
# -*- coding: utf-8 -*-
import random
from math import floor

def compare_entier_croissant(a, b):
    """
    :param a: (int) un entier
    :param b: (int) un entier
    :return: (int)  
             * >0  si a est supérieur à b
             * 0 si a est égal à b
             * <0 si a est inférieur à b
    :CU: aucune
    :Exemples:

    >>> compare_entier_croissant(1, 3) < 0
    True
    """
    return a-b

def compare_entier_décroissant(a, b):
    """
    :param a: (int) un entier
    :param b: (int) un entier
    :return: (int) 
             * >0 si a est inférieur à b
             * 0 si a est égal à b
             * <0 si a est supérieur à b
    :CU: aucune
    :Exemples:

    >>> compare_entier_décroissant(1, 3) > 0
    True
    """
    return b-a
    

def cree_liste_melangee(n):
    """
    :param n: (int) Longueur de la liste à créer
    :return: une permutation des n premiers entiers
    :CU: n >= 0
    :Exemples:
        
    >>> l = cree_liste_melangee(5)
    >>> len(l)
    5
    >>> sorted(l) == [0, 1, 2, 3, 4]
    True
    """
    l = list(range(n))
    random.shuffle(l)
    return l

def echange(l,i,j):
    temp=l[i]
    l[i]=l[j]
    l[j]=temp

################################################
#                TRI 1  (...)                  #
################################################

def tri_1(l, comp):
    """
    :param l: (list) une liste
    :param comp: une fonction de comparaison
    :CU: Les éléments de l doivent être comparables 
   
    :Effet de bord: modifie la liste l en triant ses éléments selon l'ordre 
        défini par comp, du plus petit au plus grand
    :Exemples:
    
    >>> l = [3, 1, 4, 1, 5, 9, 2]
    >>> tri_1(l, compare_entier_croissant)
    >>> l == [1, 1, 2, 3, 4, 5, 9]
    True
    """
    for i in range(len(l)):
        p=len(l)
        for j in range(p-1):
            if comp(l[j],l[j+1])>0:
                echange(l,j,j+1)
        p=p-1
        

################################################
#                TRI 2  (...)                  #
################################################

def tri_2(l, comp):
    """
    :param l: (list) une liste
    :param comp: une fonction de comparaison
    :CU: Les éléments de l doivent être comparables 
   
    :Effet de bord: modifie la liste l en triant ses éléments selon l'ordre 
        défini par comp, du plus petit au plus grand
    :Exemples:
    
    >>> l = [3, 1, 4, 1, 5, 9, 2]
    >>> tri_2(l, compare_entier_croissant)
    >>> l == [1, 1, 2, 3, 4, 5, 9]
    True
    """
    n = len(l)
    for i in range(1, n):
        tmp = l[i]
        k = i
        while k >= 1 and comp(tmp, l[k - 1]) < 0 :
            l[k] = l[k - 1]
            k = k - 1
        l[k] = tmp

################################################
#                   TRI 3 (...)                #
################################################

def tri_3(l,comp):
    """
    :param l: (list) une liste
    :param comp: une fonction de comparaison
    
    :CU: Les éléments de l doivent être comparables
    
    :Exemples :
    >>> l=[12,3,7,8,1,5,11,13,2]
    >>> tri_3(l,compare_entier_croissant)
    >>> l
    [1, 2, 3, 5, 7, 8, 11, 12, 13]
    >>> tri_3(l,compare_entier_décroissant)
    >>> l
    [13, 12, 11, 8, 7, 5, 3, 2, 1]
    """
    for i in range(len(l)):
        min=i
        for j in range(i+1,len(l)):
            if comp(l[j],l[min])<0:
                min=j
        echange(l,i,min)

################################################
#                 TRI 4   (tri rapide)         #
################################################

def tri_4(l,comp):
    """
    :param l: (list) une liste
    :param comp: une fonction de comparaison
    
    :CU: Les éléments de l doivent être comparables
    
    :Exemples :
    """
    if len(l)==0:
        return []
    else:
        tabInf=[]
        tabSup=[]
        for i in range(len(l)-1):
            if comp(l[i],l[len(l)-1])<0:
                tabInf.append(l[i])
            else:
                tabSup.append(l[i])
        return tri_4(tabInf,comp)+[l[len(l)-1]]+tri_4(tabSup,comp)
                