from timeit import timeit
import pylab

def mesure_longueur(n,tri):
    '''
    renvoie le temps en secondes pour effectuer 100 tris sur des listes mélangées de taille n
    UC: n entier strictement positif, tri 1 2 3 ou 4
    '''
    t=timeit(setup='from tris import tri_'+str(tri)+'; from listes import cree_liste_melangee; from tris import compare_entier_croissant', stmt='tri_'+str(tri)+'(cree_liste_melangee('+str(n)+'),compare_entier_croissant)', number=100)
    return t

def mesure_longueur_max(n,tri):
    '''
    calcule les temps mis pour effectuer 100 tris sur des listes mélangées de taille i
    chaque temps est placé dans le tableau tab_temps
    UC: n entier strictement positif, tri 1 2 3 ou 4
    
    '''
    tab_temps=[0]*n
    for i in range (1,n+1):
        t=timeit(setup='from tris import tri_'+str(tri)+'; from listes import cree_liste_melangee; from tris import compare_entier_croissant', stmt='tri_'+str(tri)+'(cree_liste_melangee('+str(i)+'),compare_entier_croissant)', number=100)
        tab_temps[i-1]=t
    return tab_temps


def mesure_longueur_max_py(n):
    '''
    calcule les temps mis pour effectuer 100 tris sur des listes mélangées de taille i
    chaque temps est placé dans le tableau tab_temps
    UC: n entier strictement positif, tri sort()
    
    '''
    tab_temps=[0]*n
    for i in range (1,n+1):
        t=timeit(setup='from listes import cree_liste_melangee', stmt='sorted(cree_liste_melangee('+str(i)+'))', number=100)
        tab_temps[i-1]=t
    return tab_temps

def trace_1(tab):
    '''
    affichage simple
    '''
    pylab.plot(tab)
    pylab.show()

def trace_2(nmax):
    '''
    tri par selection
    affichage avec légendes
    '''
    tab=mesure_longueur_max(nmax,1)
    NBRE_ESSAIS=100
    pylab.title('Temps du tri 1 (pour {:d} essais)'.format(NBRE_ESSAIS))
    pylab.xlabel('taille des listes')
    pylab.ylabel('temps en secondes')
    pylab.grid()
    pylab.plot(tab)
    pylab.show()
    
def trace_3(nmax,tri):
    '''
    param tri : integer
    param nmax : integer>0
    affiche le graphique associé à tri ("1 2 3 ou 4")
    UC : tri = 1 2 3 ou 4, nmax entier strictement positif
    '''
    tab=mesure_longueur_max(nmax,tri)
    NBRE_ESSAIS=100
    pylab.title('Temps du tri '+str(tri)+' (pour {:d} essais)'.format(NBRE_ESSAIS))
    pylab.xlabel('taille des listes')
    pylab.ylabel('temps en secondes')
    pylab.grid()
    pylab.plot(tab)
    pylab.show()
    
    
def trace_all(nmax):
    tab1=mesure_longueur_max(nmax,1)
    tab2=mesure_longueur_max(nmax,2)
    tab3=mesure_longueur_max(nmax,3)
    tab4=mesure_longueur_max(nmax,4)
    tab=mesure_longueur_max_py(nmax)
    NBRE_ESSAIS=100
    pylab.xlabel('taille des listes')
    pylab.ylabel('temps en secondes')
    pylab.grid()
    pylab.plot(tab1,color='red')
    pylab.plot(tab2,color='orange')
    pylab.plot(tab3,color='black')
    pylab.plot(tab4,color='blue')
    pylab.plot(tab,color='green')
    pylab.show()
